@ECHO off
REM Watches target file, saves a new copy with time stamp every time the file changes.
REM By default SAVE10.GAM in current directory is watched, but you can provide target
REM name as an argument. For example to store saves in subdirectory SAVES put this
REM batch there and run:
REM
REM   watch-save10.bat ..\SAVE10.GAM
REM
REM A simple way to do it is to create a shortcut for this file and append the argument
REM to shortcut\target in its properties.

SET file=%1
if "%1" == "" (
    SET file=SAVE10.GAM
    SET name=SAVE10.GAM
) ELSE (
    SET file=%1
    FOR %%i IN ("%file%") DO SET name=%%~ni
)
ECHO watching %file%

:loop
IF NOT EXIST "%file%" (
    ECHO file %file% does not exist
    GOTO next
)
FOR /F "usebackq" %%A IN ('%file%') DO SET size=%%~zA
IF %size% LSS 208000 (
    ECHO file is too small, ignoring
    GOTO next
)

COPY "%file%" tmp1 > nul
IF EXIST "tmp2" (
    fc tmp1 tmp2 > nul
    IF NOT ERRORLEVEL 1 GOTO next
)
COPY tmp1 tmp2 > nul

FOR /f "delims=" %%a in ('wmic OS Get localdatetime  ^| find "."') do set dt=%%a
SET stamp=%dt:~0,4%-%dt:~4,2%-%dt:~6,2%_%dt:~8,2%-%dt:~10,2%-%dt:~12,2%-%dt:~15,4%
ren tmp1 "%name%.%stamp%"
ECHO created "%name%.%stamp%"

:next
timeout /t 1 > nul
GOTO loop