-- This is a player context script for MoO2 1.50 patch project.
--
-- This script shows you galaxy exploration information.
--
-- To run the script press 3 in main screen (the file should be named MAIN3.LUA)

stars = get_stars()
planets = get_planets()

BLACK_HOLE_COLOUR = 6

-- 0 counts as well in this case
nr_gal = #stars + 1
nr_stars = #stars + 1
nr_bhs = 0
explored = 0
names = ""
for i, s in pairs(stars) do
    -- even if the name is seen on the map, it only shows up in data if explored/omniscient
	if s.name ~= nil then
		explored = explored + 1
	end
	if s.color == BLACK_HOLE_COLOUR then
		nr_stars = nr_stars - 1
        nr_bhs = nr_bhs + 1
	end
end

nr_planets = 0
nr_asteroids = 0
nr_gas_giants = 0
for i, p in pairs(planets) do
	if p.type == 3 then
		nr_planets = nr_planets + 1
	elseif p.type == 1 then
		nr_asteroids = nr_asteroids + 1
	elseif p.type == 2 then
		nr_gas_giants = nr_gas_giants + 1
	end
end
nr_satellites = nr_planets + nr_asteroids + nr_gas_giants

output = "Galaxy data known to us:"
output = output .. "\n"
output = output .. "\n" .. nr_stars .. " stars"
output = output .. "\n" .. nr_bhs .. " black holes"
output = output .. "\n"
output = output .. "\n" .. "Seen " .. explored .. " stars, with " .. nr_satellites .. " satellites:"
output = output .. "\n"
output = output .. "\n" .. nr_planets .. " planets"
output = output .. "\n" .. nr_asteroids .. " asteroid belts"
output = output .. "\n" .. nr_gas_giants .. " gas giants"
-- output = output .. "\n" .. "Explored: " .. explored .. " stars, " .. nr_satellites .. " satellites" .. " (" .. tostring(get_rounded_percent(explored, nr_stars)) .. "%)"
msgbox(output)
