-- CRYOGEN CLONE for VDC
--
-- This is a newgame postprocessor script for VDC.
-- It modifies the tech tree for Uncreative human players.

for pi,p in pairs(get_players()) do
    if p.uncreative == 1 and p.is_human == 1 then
        t = get_player_techs(pi)
        r = random(3)
        if t.zortrium_armor == 0 and t.neutronium_armor == 0 and t.adamantium_armor == 0 and r == 1 then
            t.zortrium_armor = 1
            t.nano_disassemblers = 0
            t.zeon_missile = 0
        end
        if t.zortrium_armor == 0 and t.neutronium_armor == 0 and t.adamantium_armor == 0 and r == 2 then
            t.neutronium_armor = 1
            t.microlite_construction = 0
            t.uridium_fuel_cells = 0
        end
        if t.zortrium_armor == 0 and t.neutronium_armor == 0 and t.adamantium_armor == 0 and r == 3 then
            t.adamantium_armor = 1
            t.thorium_fuel_cells = 0
        end
        if t.planetary_supercomputer == 0 then
            t.planetary_supercomputer = 1
            t.optronic_computer = 0             -- optronic computer = vdc positronic computer
            t.virtual_reality_network = 0
        end
        if t.positronic_computer == 0 and t.cybertronic_computer == 0 and t.moleculartronic_computer == 0 then
            t.cybertronic_computer = 1
            t.achilles_targeting_unit = 0
        end
        if t.evolutionary_mutation == 0 then
            t.evolutionary_mutation = 1
            t.android_workers = 0
        end
        if t.anti_matter_bomb == 0 then
            t.anti_matter_bomb = 1
            t.neutron_blaster = 0
            t.neutron_scanner = 0
        end
        if (t.anti_matter_torpedo == 1 and t.proton_torpedo == 1 and t.plasma_torpedo == 1) or
           (t.anti_matter_torpedo == 0 and t.proton_torpedo == 1 and t.plasma_torpedo == 1) or
           (t.anti_matter_torpedo == 1 and t.proton_torpedo == 0 and t.plasma_torpedo == 1) or
           (t.anti_matter_torpedo == 1 and t.proton_torpedo == 1 and t.plasma_torpedo == 0) then
            t.disrupter_cannon = 0
            t.neutronium_bomb = 0
            t.particle_beam = 0
            t.sensors = 1
        end
        if t.class_v_shield == 0 then           -- class v shield = vdc class vii shield
            t.class_v_shield = 1
            t.gauss_cannon = 0
            t.wide_area_jammer = 0
        end
        if t.hard_shields == 0 then
            t.hard_shields = 1
            t.reflection_field = 0
        end
        -- msgbox("setting techs for ", pi, " ", p.race)
        set_player_techs(pi, t)
    end
end

for pi,p in pairs(get_players()) do
    if p.uncreative == 1 and p.is_human == 1 then
        t = get_player_techs(pi)
        if t.disrupter_cannon == 0 and t.death_ray == 0 and t.mauler_device == 0 then
            t.mauler_device = 1
            t.phase_shifter = 0
            t.death_spores = 0                  -- death spores = vdc phase bomb
        end
        if (t.merculite_missile == 1 and t.pulson_missile == 1 and t.zeon_missile == 1) or
           (t.merculite_missile == 0 and t.pulson_missile == 1 and t.zeon_missile == 1) or
           (t.merculite_missile == 1 and t.pulson_missile == 0 and t.zeon_missile == 1) then
            t.anti_matter_bomb = 0
            t.neutron_blaster = 0
            t.neutron_scanner = 1
        end
        if t.merculite_missile == 1 and t.pulson_missile == 1 and t.zeon_missile == 0 then
            t.anti_matter_bomb = 0
            t.neutron_blaster = 0
            t.neutron_scanner = 1
            t.fusion_bomb = 1
            t.fusion_beam = 0
            t.fusion_rifle = 0
        end
        -- msgbox("setting techs for ", pi, " ", p.race)
        set_player_techs(pi, t)
    end
end

for pi,p in pairs(get_players()) do
    if p.uncreative == 1 and p.government <= 5 and p.is_human == 1 then
        t = get_player_techs(pi)
        if t.holo_simulator == 0 then
            t.holo_simulator = 1
            t.dauntless_guidance_system = 0
            t.neural_scanner = 0
        end        
        -- msgbox("setting techs for ", pi, " ", p.race)
        set_player_techs(pi, t)
    end
end

for pi,p in pairs(get_players()) do
    if p.uncreative == 1 and p.is_human == 1 then
        t = get_player_techs(pi)
        if t.cloning_center == 0 then
            t.cloning_center = 1
            t.subterranean_farms = 0          
        end        
        -- msgbox("setting techs for ", pi, " ", p.race)
        set_player_techs(pi, t)
    end
end
for pi,p in pairs(get_players()) do
    if p.uncreative == 1 and p.is_human == 1 then
        t = get_player_techs(pi)
        if t.spaceport == 0 then
            t.spaceport = 1
            t.alien_management_center = 0          
        end        
        -- msgbox("setting techs for ", pi, " ", p.race)
        set_player_techs(pi, t)
    end
end

for pi,p in pairs(get_players()) do
    if p.uncreative == 1 and p.highg_world == 1 and p.is_human == 1 then
        t = get_player_techs(pi)
        r = random(2)
        if t.planetary_gravity_generator == 1 and r == 1 then
            t.planetary_gravity_generator = 0
            t.anti_grav_harness = 1
            t.graviton_beam = 0
        end
        if t.planetary_gravity_generator == 1 and r == 2 then
            t.planetary_gravity_generator = 0
            t.anti_grav_harness = 0
            t.graviton_beam = 1            
        end
        -- msgbox("setting techs for ", pi, " ", p.race)
        set_player_techs(pi, t)
    end
end

for pi,p in pairs(get_players()) do
    if p.uncreative == 1 and p.tolerant == 0 and p.is_human == 1 then
        t = get_player_techs(pi)
        if t.pollution_processor == 0 and t.atmospheric_renewer == 0 and t.nano_disassemblers == 0 then
            t.core_waste_dumps = 1
            t.battlestation = 0
            t.titan_construction = 0
        end
        -- msgbox("setting techs for ", pi, " ", p.race)
        set_player_techs(pi, t)
    end
end

for pi,p in pairs(get_players()) do
    if p.uncreative == 1 and p.lithovore == 1 and p.is_human == 1 then
        t = get_player_techs(pi)
        r = random(2)
        if t.weather_control_system == 1 and r == 1 then
            t.weather_control_system = 0
            t.psionics = 1
            t.universal_antidote = 0
        end
        if t.weather_control_system == 1 and r == 2 then
            t.weather_control_system = 0
            t.psionics = 0
            t.universal_antidote = 1
        end
        -- msgbox("setting techs for ", pi, " ", p.race)
        set_player_techs(pi, t)
    end
end

-- HOME WORLD for VDC

-- This is a newgame postprocessor script for VDC.
-- It modifies the home world as follows:
--   HIGH-G Homeworld is +1 size for all players. [and p.lithovore == 1]
--     [ Medium becomes Large. ]
--     [ Large becomes Huge. ]
--   subtolerant gets gaia hw;
--   lucky pick gets either gold for hw or super artifact world;


for pi,p in pairs(get_players()) do
    if p.highg_world == 1 then
		local planets = get_planets()
		local star_id = planets[p.home_planet].star
		local orbits = get_stars()[star_id].orbits
		for _, planet_id in pairs(orbits) do
			if planets[planet_id].climate == 6 then -- swamp
				set_planets({[planet_id] = {size = 4}}) 	
			end
		end
		planets = nil
		star_id = nil
		orbits = nil
        if p.large_hw == 1 then
		    set_planets({[p.home_planet] = {size = 4}}) 
        end
    end
    if p.tolerant == 1 and p.subterranean == 1 then
        set_planets({[p.home_planet] = {food_base = 6, climate = 9}})
    end
    if p.lucky == 1 and p.arti_world == 1 then
        set_planets({[p.home_planet] = {special = 11}})
    end
    if p.lucky == 1 and p.arti_world == 0 then
        set_planets({[p.home_planet] = {special = 4}})

    end
end