-- This is a newgame postprocessor script for MoO2 1.50 patch project.
--
-- Generates mirrored home systems for multiplayer.

padx = 50
pady = 50
scale = 90
set_seed() -- randomize
-- msgbox("copying home system uninhabited orbits")

function initialize_player_dependend_information(players, planets, stars)
	local home_systems = {}
	local nr_players = 0
    for i, player in pairs(players) do
		local home_system = stars[planets[player.home_planet].star]
		nr_players = nr_players + 1
		table.insert(home_systems, home_system)
	end
	return nr_players, home_systems
end

game = get_game()

if game.num_players == 9 then -- 9 = random opponents id
    number = 2
else
    number = game.num_players
end

z = random(number)
-- msgbox("from player number " .. z)

function tsize(t)
    local i = 0
    for k, v in pairs(t) do
        i = i + 1
    end
    return i
end

function abs(v)
    if v < 0 then return -v else return v end
end

function max(a, b)
    if a > b then return a else return b end
end

function min(a, b)
    if a <= b then return a else return b end
end

function bbox(b, obj)
    if b == nil then
        b = { x1 = obj.x, y1 = obj.y, x2 = obj.x, y2 = obj.y }
    end
    b.x1, b.x2 = min(b.x1, obj.x), max(b.x2, obj.x)
    b.y1, b.y2 = min(b.y1, obj.y), max(b.y2, obj.y)
    return b
end

function tbbox(t)
    local b
    for k, v in pairs(t) do
        b = bbox(b, v)
    end
    return b
end

function get_homes()
    local pp = get_planets()
    local ss = get_stars()
    local homes = {}
    for i, y in pairs(get_players()) do
        local sid = pp[y.home_planet].star
        ss[sid].playerid = i
        ss[sid].homeplanet = y.home_planet
        table.insert(homes, ss[sid])
    end
    table.sort(homes, function(a, b) return a.playerid < b.playerid end)
    return ss, pp, homes
end

function go()
    set_stars({}) -- early check that we're in universal context
 
    -- store home stars in homes array
    local ss, pp, homes = get_homes()

    -- strip other homeworlds to simplify cloning later
    local del_pp = {}
	table.remove(homes, z)
    for ii, s in ipairs(homes) do
        for o, op in pairs(s.orbits) do
            if op ~= s.homeplanet then
                table.insert(del_pp, op)
            end
       	end	
    end
    del_planets(del_pp)	
	
    -- reread everything, since star ids has changed after deletion
    local ss, pp, homes = get_homes()
    local home = table.remove(homes, z)

    -- adjust other homes orbits to match best home's orbit
    for ii, s in ipairs(homes) do
        if pp[s.homeplanet].orbit ~= pp[home.homeplanet].orbit then
            set_planets({ [s.homeplanet] = { orbit = pp[home.homeplanet].orbit }})
        end
    end

    -- mirror home systems
    for ii, s in ipairs(homes) do
        for o, op in pairs(home.orbits) do
            if op ~= -1 and op ~= home.homeplanet then
                pp[op].star = s.id
                add_planets({pp[op]})
            end
        end
    end

end

msgbox("mirrored home system from player " .. z)

go()
